/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.pt.impl;

import com.cisco.pt.EncodedBuffer;
import com.cisco.pt.impl.LTVImpl;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class IPCResponseLTV
extends LTVImpl {
    protected int messageId;
    protected Object innerValue;
    private static Log logger = LogFactory.getLog(IPCResponseLTV.class);

    public IPCResponseLTV(int messageId) {
        this.messageId = messageId;
        this.setType(102);
    }

    public boolean isResponse() {
        return true;
    }

    public int getMessageId() {
        return this.messageId;
    }

    public void encodeTypeAndPayload(EncodedBuffer buff) {
        logger.warn((Object)"IPCResponseLTV.encodeTypeAndPayload not implemented");
    }

    public boolean getBoolValue() {
        if (this.innerValue == null) {
            throw new Error("Attempt to retrieve boolean from a null IPCResponseLTV");
        }
        return (Boolean)this.innerValue;
    }

    public byte getByteValue() {
        if (this.innerValue == null) {
            throw new Error("Attempt to retrieve byte from a null IPCResponseLTV");
        }
        return (Byte)this.innerValue;
    }

    public double getDoubleValue() {
        if (this.innerValue == null) {
            throw new Error("Attempt to retrieve double from a null IPCResponseLTV");
        }
        return (Double)this.innerValue;
    }

    public float getFloatValue() {
        if (this.innerValue == null) {
            throw new Error("Attempt to retrieve float from a null IPCResponseLTV");
        }
        return ((Float)this.innerValue).floatValue();
    }

    public int getIntValue() {
        if (this.innerValue == null) {
            throw new Error("Attempt to retrieve int from a null IPCResponseLTV");
        }
        return (Integer)this.innerValue;
    }

    public long getLongValue() {
        if (this.innerValue == null) {
            throw new Error("Attempt to retrieve long from a null IPCResponseLTV");
        }
        return (Long)this.innerValue;
    }

    public short getShortValue() {
        if (this.innerValue == null) {
            throw new Error("Attempt to retrieve short from a null IPCResponseLTV");
        }
        return (Short)this.innerValue;
    }

    public Object getObjectValue() {
        return this.innerValue;
    }

    public void setValue(Object innerValue) {
        this.innerValue = innerValue;
    }
}

